/* Display html code which is defined in inputId into the element found in outputId
   if inputId is not defined, it looks up the first tag with this name.
*/
function displayHTML(inputId,outputId) {
    var styleDisplay = document.querySelector('#'+outputId);
    var element = document.getElementById(inputId);
    if (element==null)
      element = document.getElementsByTagName(inputId)[0];
    let elementText = element.outerHTML;
    elementText = elementText.replaceAll('<','&lt;').replaceAll('>','&gt;');    
    elementText = elementText.replaceAll(/&lt;\/(.*?)&gt;/g,'<br>&lt;/$1&gt;');
    elementText = elementText.replaceAll('&gt;','&gt;<br>');
    styleDisplay.innerHTML = elementText;
}


/* Displays all styles that are defined in element inputId in element outputId
   Written by chatGPT.
<pre>
This is paragraph 1 (p1).

Display Styles for p1:

.styles1 {
font-weight: bold;
color: red;
}

.styles2 {
background-color: gold;
color: black;
}
</pre>
*/

function displayStyles(inputId,outputId) {
    var styleDisplay = document.querySelector('#'+outputId);
    var matchingRules = [];
    var element = document.getElementById(inputId);
    
    // Get all the classes applied to the element
    var classes = element.className.split(/\s+/);
    
    var styleHTML = '';
    // Iterate through all the stylesheets in the document
    for (var i = 0; i < document.styleSheets.length; i++) {
      var stylesheet = document.styleSheets[i];
      //dismiss stuff from google
      if (stylesheet.href!=null && stylesheet.href.indexOf("google")!=-1) continue; 
      try {
      // Iterate through all the rules in the stylesheet
      for (var j = 0; j < stylesheet.cssRules.length; j++) {
        var rule = stylesheet.cssRules[j];
        // Check if the rule matches any of the classes applied to the element
        for (var k = 0; k < classes.length; k++) {
          var className = '.' + classes[k];
          if (rule.selectorText.indexOf(className)!=-1) {
            matchingRules.push(rule);
          }
        }
      }
      } catch(e) {console.log("Exception caught:"+e);}
    }
    
    // Iterate through all the matching rules
    
    for (var i = 0; i < matchingRules.length; i++) {
      var rule = matchingRules[i];
      rule = rule.cssText;      
      rule = rule.replaceAll(" {","{");
      rule = rule.replaceAll(/[ ](.+?);/g,"<br><span style='margin-left:1rem'>$1;</span>");
      rule = rule.replaceAll("}","<br>}");
      styleHTML += rule;
      /* this is too much ... 
      styleHTML += rule.selectorText+" {<br>";
      // Iterate through all the defined properties in the rule      
      for (var j = 0; j < rule.style.length; j++) {
        var property = rule.style[j];
        var value = rule.style.getPropertyValue(property);
        styleHTML += '<span style="margin-left: 1em;" class="styleDisplay-property">' + property + "</span>"+
                     ': <span class="styleDisplay-value">' + value + '</span>;<br>';
      }
      styleHTML+='}<br><br>';
      */
      styleHTML+='<br><br>';
    }
    styleDisplay.innerHTML = styleHTML;
  }
  