﻿using NUnit.Framework;

namespace renamerV2
{
    [TestFixture]
    public class NUnitTests
    {
        [Test]
        public void TestRename()
        {
            RenamingElement element = new RenamingElement("file1.txt", "file2.txt");
            string result = element.Rename("file1.txt");
            Assert.AreEqual("file2.txt", result);
        }

        //Function not implemented
        /*
        [Test]
        public void TestRenameWithNumber()
        {
            RenamingElement element = new RenamingElement("file1.txt", "file2.txt");
            string result = element.Rename("file1_123.txt");
            Assert.AreEqual("file2_123.txt", result);
        }*/

        [Test]
        public void TestRenameWithWrongExtension()
        {
            RenamingElement element = new RenamingElement("file1.txt", "file2.txt");
            string result = element.Rename("file1.jpg");
            Assert.AreEqual("file1.jpg", result);
        }

        [Test]
        public void TestRenameWithReplace()
        {
            RenamingElement element = new RenamingElement("file*.txt", "new*.txt");
            string result = element.Rename("file123.txt");
            Assert.AreEqual("new123.txt", result);
        }

        [Test]
        public void TestRenameWithReplaceAndExtension()
        {
            RenamingElement element = new RenamingElement("file*.txt", "new*.jpg");
            string result = element.Rename("file123.txt");
            Assert.AreEqual("new123.jpg", result);
        }

        [Test]
        public void TestRenameWithReplaceAndAlphabeticalAdventure()
        {
            RenamingElement element = new RenamingElement("file*.txt", "new*.txt");
            string result = element.Rename("fileabc.txt");
            Assert.AreEqual("newabc.txt", result);
        }

        [Test]
        public void TestRenameWithReplaceAndAlphabeticalAdventureAndExtension()
        {
            RenamingElement element = new RenamingElement("file*.txt", "new*.jpg");
            string result = element.Rename("fileabc.txt");
            Assert.AreEqual("newabc.jpg", result);
        }

        [Test]
        public void TestRenameWithNoMatch()
        {
            RenamingElement element = new RenamingElement("file1.txt", "file2.txt");
            string result = element.Rename("file3.txt");
            Assert.AreEqual("file3.txt", result);
        }

        [Test]
        public void TestRenameWithNoNumber()
        {
            RenamingElement element = new RenamingElement("file1.txt", "file2.txt");
            string result = element.Rename("file.txt");
            Assert.AreEqual("file.txt", result);
        }

        [Test]
        public void TestAddNewNumber()
        {
            RenamingElement element = new RenamingElement("file.txt", "1-file.txt");
            string[] files = new string[] { "file.txt", "file.txt", "file.txt", "file.txt", "file.txt" };
            string[] expected = new string[] { "1-file.txt", "2-file.txt", "3-file.txt", "4-file.txt", "5-file.txt" };
            for (int i = 0; i < files.Length; i++)
            {
                string result = element.Rename(files[i]);
                Assert.AreEqual(expected[i], result);
            }
        }

        [Test]
        public void TestRenameWithNumberRequired()
        {
            RenamingElement element = new RenamingElement("file1.txt", "file2.txt");
            string result = element.Rename("file.txt");
            Assert.AreEqual("file.txt", result);
        }

        [Test]
        public void TestReplacementIsPartOfOriginal()
        {
            RenamingElement element = new RenamingElement("img*1.jpg", "i*1.jpg");
            string result = element.Rename("img12.jpg");
            Assert.AreEqual("i12.jpg", result);
        }

        [Test]
        public void TestAddZero()
        {
            RenamingElement element = new RenamingElement("img1.jpg", "img001.jpg");
            string result = element.Rename("img1.jpg");
            Assert.AreEqual("img001.jpg", result);
        }

        [Test]
        public void TestRemoveZero()
        {
            RenamingElement element = new RenamingElement("img001.jpg", "img1.jpg");
            string result = element.Rename("img001.jpg");
            Assert.AreEqual("img1.jpg", result);
        }
    }
}