public class Spiralizor {

    static int RIGHT=0,DOWN=1,LEFT=2,UP=3;
    static int[][] field = null;
    static int xCurr;
    static int yCurr;

    public static int[][] spiralize(int size) {
        xCurr=0;
        yCurr=0;
        field = new int[size][size];
        spiraleIt();
        return field;
    }

    private static void spiraleIt() {
      boolean end=false;
      while(!end) {
          boolean b1=move(RIGHT);
          boolean b2=move(DOWN);
          boolean b3=move(LEFT);         
          boolean b4=move(UP);
          if (!b1||!b2||!b3||!b4) break;
      }
    }
    
    private static boolean move(int dir) {
        if (yCurr>=field.length || yCurr<0 ||
            xCurr>=field.length || xCurr<0) return false;
        boolean moving=false;
        if (dir==RIGHT) {
            do {
               if (xCurr + 1 < field.length && field[yCurr][xCurr + 1] == 1) {
                   if (!moving) return false;
                   xCurr--;
                   break;
               }
               field[yCurr][xCurr] = 1;           
               xCurr++;
               moving = true;
            } while (xCurr<field.length-1);
        }
        else if (dir==DOWN) {
            do {
               if (yCurr + 1 < field.length && field[yCurr+1][xCurr] == 1) {                   
                   if (!moving) return false;
                   yCurr--;
                   break;
               }
               field[yCurr][xCurr] = 1;           
               yCurr++;
               moving = true;
            } while (yCurr<field.length-1);
        }
        else if (dir==LEFT) {
            do {
               if (xCurr - 1 >= 0 && field[yCurr][xCurr - 1] == 1) {
                   if (!moving) return false;
                   xCurr++;                   
                   break;
               }
               field[yCurr][xCurr] = 1;           
               xCurr--;
               moving = true;
            } while (xCurr>=1);
        }
        else if (dir==UP) {
            do {
               if (yCurr - 1 < field.length && field[yCurr-1][xCurr] == 1) {
                   if (!moving) return false;
                   yCurr++;                   
                   break;
               }
               field[yCurr][xCurr] = 1;           
               yCurr--;
               moving = true;
            } while (yCurr>=1);
        }        
        return moving;
    } 
                
    private static void print() {
        for (int z = 0; z < field.length; z++) {
            for (int s = 0; s < field.length; s++) {
                System.out.print(field[z][s] + " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    public static void main(String[] args) {
        
        
        spiralize(1);
        print();
        spiralize(2);
        print();
        spiralize(3);
        print();
        spiralize(4);
        print();
        //spiralize(5);
        //spiralize(3);
        //spiralize(2);
        //spiralize(12);
        //print();
        //spiralize(8);
    }

}
