
import java.util.ArrayList;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author bal
 */
public class Zahlwoerter {
    
    public static String[] einer = {"null","ein","zwei","drei","vier","fünf",
                           "sechs","sieben","acht","neun"};
    public static String[] zehner = {"zehn","elf","zwölf","dreizehn","vierzehn","fünfzehn",
                           "sechszehn","siebzehn","achtzehn","neunzehn"};
    public static String[] hunderter = {"","","zwanzig","dreizig","vierzig","fünfzig",
                            "sechzig","siebzig","achtzig","neunzig"};
    public static String[] tausender = {"hundert","tausend","millionen","milliarden"};
    

    /** Methode zum Berechnen der Lösung mit dem Datentyp int, 
     * das bedeutet nur bis 2 Milliarden */

    public static String num2word(int zahl) {
        String erg="";
        if (zahl==1) return einer[zahl]+"s";
        if (zahl<10) return einer[zahl];
        if (zahl<20) return zehner[zahl-10];
        if (zahl<100) {
            int z2=zahl/10;
            int z1=zahl%10;
            if (z1==0)
              return hunderter[z2];
            else
              return einer[z1]+"und"+hunderter[z2];
        }
        if (zahl<1_000) {
            int z3=zahl/100;
            int z2=zahl%100/10;
            int z1=zahl%10;
            erg = einer[z3]+"hundert";
            if (z2==0&&z1==0)
              return erg;
            else
              return erg+num2word(z2*10+z1);
        }
        if (zahl<10_000) {
            int z4=zahl/1000;
            int z3=zahl%1000/100;
            int z2=zahl%100/10;
            int z1=zahl%10;
            erg = einer[z4]+"tausend";
            if (z3==0&&z2==0&&z1==0)
              return erg;
            else
              return erg+num2word(z3*100+z2*10+z1);
        }
        if (zahl<1_000_000) {
            int tausend=zahl/1000;
            int hundert=zahl%1000;
            erg = num2word(hundert);
            if (erg.equals("null")) 
              return num2word(tausend)+"tausend";
            else 
              return num2word(tausend)+"tausend"+erg;
        }

        if (zahl<1_000_000_000) {
            int millionen=zahl/1_000_000;
            int tausend=zahl%1_000_000;
            if (millionen==1) 
               erg="einemillion"; 
            else
               erg=num2word(millionen)+"millionen";
            return erg+num2word(tausend);
        }

        if (zahl<2_000_000_000) {
            int milliarden=zahl/1_000_000_000;
            int millionen=zahl%1_000_000_000;
            if (milliarden==1) 
               erg="einemilliarde"; 
            else
               erg=num2word(milliarden)+"milliarden";                            
            return erg+num2word(millionen);            
        }
        return "Fehler:"+zahl;
    }
    


    /** Methode zum Berechnen der Lösung mit dem Datentyp long, 
     * das bedeutet nur bis 10 Milliarden möglich, 
     * Verwendung einer StringBuffers für mehr Effizienz.
     */
    
    
    public static String num2wordL(long zahl) {
        StringBuffer erg1= new StringBuffer();
        StringBuffer erg2= new StringBuffer();
        
        if (zahl==1) return einer[(int)zahl]+"s";
        if (zahl<10) return einer[(int)zahl];
        if (zahl<20) return zehner[(int)zahl-10];
        if (zahl<100) {
            int z2=(int)zahl/10;
            int z1=(int)zahl%10;
            if (z1==0)
              return hunderter[z2];
            else {
                erg1.append(einer[z1]);
                erg1.append("und");
                erg1.append(hunderter[z2]);
                return erg1.toString();                
            }
              
        }
        if (zahl<1_000) {
            int z3=(int)zahl/100;
            int z2=(int)zahl%100/10;
            int z1=(int)zahl%10;
            erg1.append(einer[z3]);
            erg1.append("hundert");
            if (z2==0&&z1==0)
              return erg1.toString();
            else {
               erg1.append(num2wordL(z2*10+z1)); 
               return erg1.toString();
            }
              
        }
        if (zahl<10_000) {
            int z4=(int)zahl/1000;
            int z3=(int)zahl%1000/100;
            int z2=(int)zahl%100/10;
            int z1=(int)zahl%10;
            erg1.append(einer[z4]);
            erg1.append("tausend");
            if (z3==0&&z2==0&&z1==0)
              return erg1.toString();
            else {
               erg1.append(num2wordL(z3*100+z2*10+z1)); 
               return erg1.toString();               
            }
        }
        if (zahl<1_000_000) {
            int tausend=(int)zahl/1000;
            int hundert=(int)zahl%1000;
            erg1.append(num2wordL(hundert));
            if (erg1.equals("null")) {
                erg2.append(num2wordL(tausend));
                erg2.append("tausend");
                return erg2.toString();
            } else {
                erg2.append(num2wordL(tausend));
                erg2.append("tausend");
                erg2.append(erg1);
                return erg2.toString();                    
                    }
        }

        if (zahl<1_000_000_000) {
            int millionen=(int)zahl/1_000_000;
            int tausend=(int)zahl%1_000_000;
            if (millionen==1) 
               erg1.append("einemillion"); 
            else {
                erg1.append(num2wordL(millionen));
                erg1.append("millionen");
            }

            erg2.append(erg1);
            erg2.append(num2wordL(tausend));
            return erg2.toString();                    
        }

        if (zahl<2_000_000_000) {
            int milliarden=(int)zahl/1_000_000_000;
            int millionen=(int)zahl%1_000_000_000;
            if (milliarden==1) 
               erg1.append("einemilliarde"); 
            else {
               erg1.append(num2wordL(milliarden)); 
               erg1.append("milliarden"); 
            }

            erg2.append(erg1);
            erg2.append(num2wordL(millionen));
            
            return erg2.toString();                        
        }
        return "Fehler:"+zahl;
    }


    
    public static void main(String[] args) {
        /*
        for (int i = 0; i < 1_000_000; i++) {
            System.out.println(num2word(i));
        }
        */
        //System.out.println(num2word(1_999_456_789));

        /*
        ArrayList<String> erg = new ArrayList<>();
        for (int i = 0; i < 2_000_000_000; i++) {
            //System.out.println(num2word(i));
            if (i%1_000_000==0) System.out.print(".");
            String word=num2word(i);
            if (word.startsWith("a")&&i%2!=0)
              erg.add(word);
        }
        */ 
        
        long start = System.currentTimeMillis();
        String minW="zzz";
        int min=Integer.MAX_VALUE;
        for (int i = 0; i < 2_000_000_000; i++) {
            //System.out.println(num2word(i));
            if (i%5_000_000==0) System.out.print(".");
            if (i%50_000_000==0) {
                System.out.println();
                System.out.println(min+" "+minW);
            }
            String word=num2word(i);
            if (i%2!=0 && word.compareTo(minW)<1) {
               min=i;
               minW=word;
            }                        
        }
        long end = System.currentTimeMillis();        
        System.out.println(min);
        System.out.println(((end-start)/1000)+" sec");
    }
            
}
