/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import org.junit.Test;

/**
 *
 * @author bal
 */
public class HalsketteTest {
    int BLAU=Halskette.BLAU, ROT=Halskette.ROT, 
               GELB=Halskette.GELB, GRUEN=Halskette.GRUEN;
    int B=BLAU, R=ROT, G=GELB, Gr=GRUEN;
    int[] kette1 = {B,R,B,G};
    
    public HalsketteTest() {
    }


    @Test
    public void testUngleichLaenge1() {
      int[] k1 = {B,R,B};
      int[] k2 = {B,R,B,G};
      assertEquals(false,Halskette.gleich(k1,k2));
    }
    
    @Test
    public void testUngleichLaenge2() {
      int[] k1 = {B,R,B};
      int[] k2 = {B,R};
      assertEquals(false,Halskette.gleich(k1,k2));
    }

    
    @Test
    public void testGleich() {
      int[] k1 = {B,R,B,G};
      int[] k2 = {B,R,B,G};
      assertEquals(true,Halskette.gleich(k1,k2));
    }

    @Test
    public void testGleichFalse() {
      int[] k1 = {B,R,R,G};
      int[] k2 = {B,R,B,G};
      assertEquals(false,Halskette.gleich(k1,k2));
    }

    
    @Test
    public void testGleichInvers() {
      int[] k1 = {G,B,R,B};
      int[] k2 = {B,R,B,G};
      assertEquals(true,Halskette.gleich(k1,k2));
    }

    @Test
    public void testGleichInversFalse() {
      int[] k1 = {G,B,R,B};
      int[] k2 = {B,R,B,B};
      assertEquals(false,Halskette.gleich(k1,k2));
    }
    
    
    @Test
    public void testGleichGeschlossen() {
      int[] k1 = {B,R,B,G};
      int[] k2 = {R,B,G,B};
      assertEquals(true,Halskette.gleichGeschlossen(k1,k2));
    }

    @Test
    public void testGleichGeschlossenFalse() {
      int[] k1 = {B,R,B,G};
      int[] k2 = {R,B,G,R};
      assertEquals(false,Halskette.gleichGeschlossen(k1,k2));
    }

    
    @Test
    public void testGleichGeschlossenInvers() {
      int[] k1 = {B,R,B,G};
      int[] k2 = {B,G,B,R};
      assertEquals(true,Halskette.gleichGeschlossen(k1,k2));
    }

    @Test
    public void testGleichGeschlossenInversFalse() {
      int[] k1 = {B,R,B,G};
      int[] k2 = {B,G,B,G};
      assertEquals(false,Halskette.gleichGeschlossen(k1,k2));
    }

    
    
    
}
