public class Halskette {

    static final int BLAU=0, ROT=1, GELB=2, GRUEN=3;
    static String[] farbnamen={"Blau", "Rot", "Gelb","Grün"};    

    
    public static boolean gleich(int[] k1, int[] k2) {
        //ketten gleiche Länge?
        if (k1.length!=k2.length) {
            return false;
        }
 
        //ketten gleich in richtiger Reihenfolge?
        boolean fehlerGefunden=false;
        for (int i = 0; i < k1.length; i++) {
            if (k1[i]!=k2[i]) {
                fehlerGefunden=true;
                break;
            }
        }
        if (fehlerGefunden==false) return true;
        //ketten gleich in umgekehrter Reihenfolge?
        fehlerGefunden=false;
        for (int i = 0; i < k1.length; i++) {
                int rev=k1.length-1-i;
                if (k1[i]!=k2[rev]) {
                    fehlerGefunden=true;
                    break;
                }
        }
        return !fehlerGefunden;
    }

    public static int[] invertiere (int[] kette) {
        int[] res = new int[kette.length];
        for (int i = 0; i < kette.length; i++) {
            res[i] = kette[kette.length-1-i];
        }
        return res;   
    }
    
    public static int[] rotiere (int[] kette) {
        int tmp = kette[0];
        for (int i = 0; i < kette.length-1; i++) {
           kette[i]=kette[i+1]; 
        }
        kette[kette.length-1]=tmp;
        return kette;
    }
    
    public static boolean gleichGeschlossen(int[] k1, int[] k2) {
       //Idee: rotiere Kette2 und vergleiche diese mit Kette1
       boolean gleich = false;
       for (int i = 0; i < k2.length; i++) {
           k2=rotiere(k2);
           gleich = gleich(k1,k2);
           if (gleich) return true;
        }
        return false;
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        int[] kette1 = {BLAU, ROT, GELB, ROT};
        int[] kette2 = {BLAU, ROT, GRUEN, ROT};

        if (gleich(kette1,kette2)) {
            System.out.println("Kette1 und Kette2 sind gleich");
        } else {
            System.out.println("Kette1 und Kette2 sind ungleich");
        }
        
        
        int[] kette3 = {BLAU, ROT, GRUEN, ROT};
        int[] kette4 = {BLAU, ROT, GRUEN, ROT};

        if (gleich(kette3,kette4)) {
            System.out.println("Kette3 und Kette4 sind gleich");
        } else {
            System.out.println("Kette3 und Kette4 sind ungleich");
        }

        
        int[] kette5 = {BLAU, ROT, GRUEN, ROT};
        int[] kette6 = {ROT, GRUEN, ROT, BLAU};

        if (gleich(kette5,kette6)) {
            System.out.println("Kette5 und Kette6 sind gleich");
        } else {
            System.out.println("Kette5 und Kette6 sind ungleich");
        }
        
        
        
    }
    
}
